/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.mixin.accessor.SpawnPlacementsAccessor;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.loot.RegistrateEntityLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1761;
import net.minecraft.class_1826;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5617;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;

public class EntityBuilder<T extends class_1297, P>
extends AbstractBuilder<class_1299<?>, class_1299<T>, P, EntityBuilder<T, P>> {
    private final NonNullSupplier<FabricEntityTypeBuilder<T>> builder;
    private NonNullConsumer<FabricEntityTypeBuilder<T>> builderCallback = $ -> {};
    @Nullable
    private NonNullSupplier<NonNullFunction<class_5617.class_5618, class_897<? super T>>> renderer;
    private boolean attributesConfigured;
    private boolean spawnConfigured;

    public static <T extends class_1297, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_1299.class_4049<T> factory, class_1311 classification) {
        return new EntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    protected EntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_1299.class_4049<T> factory, class_1311 classification) {
        super(owner, parent, name, callback, class_7924.field_41266);
        this.builder = () -> FabricEntityTypeBuilder.create((class_1311)classification, (class_1299.class_4049)factory);
    }

    public EntityBuilder<T, P> properties(NonNullConsumer<FabricEntityTypeBuilder<T>> cons) {
        this.builderCallback = this.builderCallback.andThen(cons);
        return this;
    }

    public EntityBuilder<T, P> renderer(NonNullSupplier<NonNullFunction<class_5617.class_5618, class_897<? super T>>> renderer) {
        if (this.renderer == null) {
            EnvExecutor.runWhenOn(EnvType.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    protected void registerRenderer() {
        this.onRegister(entry -> {
            try {
                EntityRendererRegistry.register((class_1299)entry, ((NonNullFunction)this.renderer.get())::apply);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to register renderer for Entity " + ((RegistryEntry)this.get()).getId(), e);
            }
        });
    }

    public EntityBuilder<T, P> attributes(Supplier<class_5132.class_5133> attributes) {
        if (this.attributesConfigured) {
            throw new IllegalStateException("Cannot configure attributes more than once");
        }
        this.attributesConfigured = true;
        this.onRegister(type -> FabricDefaultAttributeRegistry.register((class_1299)type, (class_5132.class_5133)((class_5132.class_5133)attributes.get())));
        return this;
    }

    public EntityBuilder<T, P> spawnPlacement(class_1317.class_1319 type, class_2902.class_2903 heightmap, class_1317.class_4306<T> predicate) {
        if (this.spawnConfigured) {
            throw new IllegalStateException("Cannot configure spawn placement more than once");
        }
        this.spawnConfigured = true;
        this.onRegister(t -> SpawnPlacementsAccessor.callRegister(t, type, heightmap, predicate));
        return this;
    }

    @Deprecated
    public EntityBuilder<T, P> defaultSpawnEgg(int primaryColor, int secondaryColor) {
        return (EntityBuilder)this.spawnEgg(primaryColor, secondaryColor).build();
    }

    @Deprecated
    public ItemBuilder<? extends class_1826, EntityBuilder<T, P>> spawnEgg(int primaryColor, int secondaryColor) {
        return this.getOwner().item(this, this.getName() + "_spawn_egg", p -> new class_1826((class_1299)((RegistryEntry)this.get()).get(), primaryColor, secondaryColor, p)).tab((class_5321<class_1761>)class_7706.field_40205).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), new class_2960("item/template_spawn_egg")));
    }

    public EntityBuilder<T, P> defaultLang() {
        return (EntityBuilder)this.lang(class_1299::method_5882);
    }

    public EntityBuilder<T, P> lang(String name) {
        return (EntityBuilder)this.lang(class_1299::method_5882, name);
    }

    public EntityBuilder<T, P> loot(NonNullBiConsumer<RegistrateEntityLootTables, class_1299<T>> cons) {
        return (EntityBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, tb -> cons.accept((RegistrateEntityLootTables)tb, (class_1299)ctx.getEntry())));
    }

    @SafeVarargs
    public final EntityBuilder<T, P> tag(class_6862<class_1299<?>> ... tags) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tags);
    }

    @Override
    protected class_1299<T> createEntry() {
        FabricEntityTypeBuilder builder = (FabricEntityTypeBuilder)this.builder.get();
        this.builderCallback.accept(builder);
        return builder.build();
    }

    @Deprecated
    protected void injectSpawnEggType(class_1299<T> entry) {
    }

    @Override
    protected RegistryEntry<class_1299<T>> createEntryWrapper(RegistryObject<class_1299<T>> delegate) {
        return new EntityEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public EntityEntry<T> register() {
        return (EntityEntry)super.register();
    }
}

